// breaker panel
// m.miller 04.11.23

#include "breaker_panel/breaker_panel_material.inc"
  
#declare panel_box = 
difference {
    #declare rad = .25 ;
    #declare sc = <92.549, 11.652, 142.957> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, -13.711, 0.000> } 
    #declare sc = <87.943, 11.652, 137.668> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, -11.200, 0.000> } 
}
   

#declare screw_count = 4 ;
#declare data1 = array[screw_count] ;
#declare data1[0] = <56.080, 0.000, 141.678>  ;
#declare data1[1] = <-60.068, 0.000, 141.291>  ;
#declare data1[2] = <-58.676, 0.000, -138.946>  ;
#declare data1[3] = <57.205, 0.000, -138.060>  ;

#declare screw_head = 
difference {
    sphere{ <0,0,0>, 1 scale <2.000, 2.000, 2.000> translate <-0.000, 0.000, 0.000> }
    #declare rad = .25 ; 
    #declare sc = <10.000, 2.000, 0.500> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 2.100, 0.000> } 
    scale <1.2,.7,1.2> 
    material {M_metal_chrome}
}


#declare breaker_void =
#declare rad = .25 ;
union { 
    #declare sc = <12.973, 7.046, 15.606> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-3.592, 0.167, 62.420> } 
    material {M_metal_chrome}
    }

#declare detail_void =
#declare rad = 1 ;
union { 
    #declare sc = <3.008, 10, 8.440> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-75.091, 1, 60.939> } 
    #declare sc = <3.008, 10, 8.440> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-75.091, 1, -80.718> } 
    #declare sc = <4.562, 10, 2.270> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <73.577, 1, 3.980> } 
    #declare sc = <4.562, 10, 2.270> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <73.577, 1, 15.105> } 
    material {M_panel_face}
}

#declare detail =
#declare rad = 1 ;
union { 
    #declare sc = <2.8, 10, 8> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-75.091, 1, 60.939> } 
    #declare sc = <2.8, 10, 8> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-75.091, 1, -80.718> } 
    #declare sc = <4.3, 10, 2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <73.577, 1, 3.980> } 
    #declare sc = <4.3, 10, 2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <73.577, 1, 15.105> } 
    material {M_panel_face}
}
  
    
#declare panel_face =
#declare rad = .25 ;
union { 
    #declare sc = <100.000, 1.000, 150.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 0.000> } 
    }


#declare panel_rise =
#declare rad = 2 ;
difference { 
    #declare sc = <85, 10, 120> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 0.000> } 

    #declare rad = 2 ;
    #declare sc = <70.000, 4.000, 110.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 11.000, 0.000> } 
    object { detail_void }
 }

    
#declare punch = cylinder { <0,0,0,>,<0,5,0>, 3} 




#declare breaker =
#declare rad = .5 ;
union {
    difference { 
        #declare sc = <16.25, 3.5, 5.5> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 0.000> } 
        
        #declare sc = <6, 3.323, 4> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-4.616, 4.5, 0.000> }
        
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <8.746, 6.4, 0.000> }  
        material {M_breaker}
    }
    union {
        #declare rad = .1 ;
        #declare sc = <1.5, 2.287, 3.407> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> rotate <0,0,20> translate <-7.357, 3.560, 0.000> material {M_breaker}} 
        
        #declare rad = .5 ;
        #declare sc = <17.139, 2.574, 6.5> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 0.000> } 
        material {M_bleaker_black_plastic}
        }
    }


#declare breaker_pair = 
union {
    object { breaker rotate <0,0,0>   translate < 20,0,0> }
    object { breaker rotate <0,180,0> translate <-20,0,0> }
}



#declare breaker_array =
union { 
    #declare gap=13;
    #for (i,0,8)
        #declare nZ = i*gap;
        object {breaker_pair translate <0,0,nZ>}
    #end 
    translate <-2.8,-7,-70.1>
}    

#declare top_breaker =
#declare rad = .25 ;
union { 
    #declare sc = <5.711, 3.592, 15.228> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-10.348, 1.141, 62.390> } 
    #declare sc = <13.393, 3.592, 16.299> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-3.990, 0.000, 62.390> } 
    #declare sc = <5.711, 3.592, 15.228> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <2.698, 1.141, 62.390> } 
    #declare sc = <4.393, 3.592, 5.630> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <2.698, 2.589, 71.015> } 
    #declare sc = <4.393, 3.592, 5.630> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-10.348, 2.589, 71.015> } 
    translate <0,-7.5,-3>
    material {M_bleaker_black_plastic}
    }


#declare bottom_breaker =
#declare rad = .25 ;
union { 
    #declare sc = <16.023, 3.592, 5.557> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-22.790, 1.141, -93.351> } 
    #declare sc = <17.985, 3.592, 6.673> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-22.756, 0.000, -93.351> } 
    translate <0,-7.5,9>
    material {M_bleaker_black_plastic}
    }



#declare breaker_panel =
union{
    difference {
        union {
            object {panel_face}
            object {panel_rise} 
            material {M_panel_face}
        }
        
        #for (i,0,screw_count-1)
            object {punch translate data1[i] material {M_panel_gray}} 
        #end 
        
        union {
            //object {breaker_void}  knock-outs
            
            #declare rad = 6 ;
            #declare sc = <55.939, 4, 96.452> ;
            object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 6.760, -9.778> } 
            material {M_panel_face}
        }
    } 
    #for (i,0,screw_count-1)
        object {screw_head translate data1[i]} 
    #end  
    
    detail
    top_breaker  
    bottom_breaker
    breaker_array
    panel_box


}               
